# IO.Swagger - the C# library for the Hanu-Betterfly Webhooks

Hanu-Betterfly webhooks endpoints documentation.

This C# SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0-oas3
- SDK version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.dotnet.CSharpClientCodegen

<a name="frameworks-supported"></a>
## Frameworks supported
- .NET 4.0 or later
- Windows Phone 7.1 (Mango)

<a name="dependencies"></a>
## Dependencies
- [RestSharp](https://www.nuget.org/packages/RestSharp) - 105.1.0 or later
- [Json.NET](https://www.nuget.org/packages/Newtonsoft.Json/) - 7.0.0 or later
- [JsonSubTypes](https://www.nuget.org/packages/JsonSubTypes/) - 1.2.0 or later

The DLLs included in the package may not be the latest version. We recommend using [NuGet](https://docs.nuget.org/consume/installing-nuget) to obtain the latest version of the packages:
```
Install-Package RestSharp
Install-Package Newtonsoft.Json
Install-Package JsonSubTypes
```

NOTE: RestSharp versions greater than 105.1.0 have a bug which causes file uploads to fail. See [RestSharp#742](https://github.com/restsharp/RestSharp/issues/742)

<a name="installation"></a>
## Installation
Run the following command to generate the DLL
- [Mac/Linux] `/bin/sh build.sh`
- [Windows] `build.bat`

Then include the DLL (under the `bin` folder) in the C# project, and use the namespaces:
```csharp
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;
```
<a name="packaging"></a>
## Packaging

A `.nuspec` is included with the project. You can follow the Nuget quickstart to [create](https://docs.microsoft.com/en-us/nuget/quickstart/create-and-publish-a-package#create-the-package) and [publish](https://docs.microsoft.com/en-us/nuget/quickstart/create-and-publish-a-package#publish-the-package) packages.

This `.nuspec` uses placeholders from the `.csproj`, so build the `.csproj` directly:

```
nuget pack -Build -OutputDirectory out IO.Swagger.csproj
```

Then, publish to a [local feed](https://docs.microsoft.com/en-us/nuget/hosting-packages/local-feeds) or [other host](https://docs.microsoft.com/en-us/nuget/hosting-packages/overview) and consume the new package via Nuget as usual.

<a name="getting-started"></a>
## Getting Started

```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class Example
    {
        public void main()
        {
            // Configure API key authorization: signature
            Configuration.Default.ApiKey.Add("betterfly-signature", "YOUR_API_KEY");
            // Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
            // Configuration.Default.ApiKeyPrefix.Add("betterfly-signature", "Bearer");

            var apiInstance = new TransactionsApi();
            var uuid = uuid_example;  // string | Transaction's uuid

            try
            {
                // Get transaction by uuid.
                TransactionResult result = apiInstance.TransactionGet(uuid);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling TransactionsApi.TransactionGet: " + e.Message );
            }
        }
    }
}
```

<a name="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TransactionsApi* | [**TransactionGet**](docs/TransactionsApi.md#transactionget) | **GET** /transaction | Get transaction by uuid.
*TransactionsApi* | [**TransactionRetryPost**](docs/TransactionsApi.md#transactionretrypost) | **POST** /transaction/retry | Retries a transaction
*UsersApi* | [**UserPost**](docs/UsersApi.md#userpost) | **POST** /user | Creates or updates an user.
*UsersApi* | [**UsersPost**](docs/UsersApi.md#userspost) | **POST** /users | Creates or updates multiple users.

<a name="documentation-for-models"></a>
## Documentation for Models

 - [Model.ResponseUnauthorized](docs/ResponseUnauthorized.md)
 - [Model.ResponseUnhandled](docs/ResponseUnhandled.md)
 - [Model.SingleSignupPayload](docs/SingleSignupPayload.md)
 - [Model.SingleSignupPayloadLocalIdentifier](docs/SingleSignupPayloadLocalIdentifier.md)
 - [Model.SingleSignupPayloadPlan](docs/SingleSignupPayloadPlan.md)
 - [Model.TransactionCreated](docs/TransactionCreated.md)
 - [Model.TransactionMultipleCreated](docs/TransactionMultipleCreated.md)
 - [Model.TransactionNotFound](docs/TransactionNotFound.md)
 - [Model.TransactionResult](docs/TransactionResult.md)
 - [Model.TransactionRetryBody](docs/TransactionRetryBody.md)
 - [Model.UsersBody](docs/UsersBody.md)
 - [Model.ValidationError](docs/ValidationError.md)
 - [Model.ValidationErrorData](docs/ValidationErrorData.md)
 - [Model.ValidationErrorDataErrors](docs/ValidationErrorDataErrors.md)
 - [Model.ValidationErrorDataErrorsFiedName](docs/ValidationErrorDataErrorsFiedName.md)

<a name="documentation-for-authorization"></a>
## Documentation for Authorization

<a name="signature"></a>
### signature

- **Type**: API key
- **API key parameter name**: betterfly-signature
- **Location**: HTTP header

