# IO.Swagger.Api.TransactionsApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**TransactionGet**](TransactionsApi.md#transactionget) | **GET** /transaction | Get transaction by uuid.
[**TransactionRetryPost**](TransactionsApi.md#transactionretrypost) | **POST** /transaction/retry | Retries a transaction

<a name="transactionget"></a>
# **TransactionGet**
> TransactionResult TransactionGet (string uuid)

Get transaction by uuid.

Retrieves a transaction status by it's uuid.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class TransactionGetExample
    {
        public void main()
        {
            // Configure API key authorization: signature
            Configuration.Default.AddApiKey("betterfly-signature", "YOUR_API_KEY");
            // Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
            // Configuration.Default.AddApiKeyPrefix("betterfly-signature", "Bearer");

            var apiInstance = new TransactionsApi();
            var uuid = uuid_example;  // string | Transaction's uuid

            try
            {
                // Get transaction by uuid.
                TransactionResult result = apiInstance.TransactionGet(uuid);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling TransactionsApi.TransactionGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uuid** | **string**| Transaction&#x27;s uuid | 

### Return type

[**TransactionResult**](TransactionResult.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="transactionretrypost"></a>
# **TransactionRetryPost**
> TransactionCreated TransactionRetryPost (TransactionRetryBody body = null)

Retries a transaction

Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class TransactionRetryPostExample
    {
        public void main()
        {
            // Configure API key authorization: signature
            Configuration.Default.AddApiKey("betterfly-signature", "YOUR_API_KEY");
            // Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
            // Configuration.Default.AddApiKeyPrefix("betterfly-signature", "Bearer");

            var apiInstance = new TransactionsApi();
            var body = new TransactionRetryBody(); // TransactionRetryBody |  (optional) 

            try
            {
                // Retries a transaction
                TransactionCreated result = apiInstance.TransactionRetryPost(body);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling TransactionsApi.TransactionRetryPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**TransactionRetryBody**](TransactionRetryBody.md)|  | [optional] 

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
