# IO.Swagger.Api.UsersApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**UserPost**](UsersApi.md#userpost) | **POST** /user | Creates or updates an user.
[**UsersPost**](UsersApi.md#userspost) | **POST** /users | Creates or updates multiple users.

<a name="userpost"></a>
# **UserPost**
> TransactionCreated UserPost (SingleSignupPayload body = null)

Creates or updates an user.

Creates a new user. If already exists, user's data will be updated.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class UserPostExample
    {
        public void main()
        {
            // Configure API key authorization: signature
            Configuration.Default.AddApiKey("betterfly-signature", "YOUR_API_KEY");
            // Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
            // Configuration.Default.AddApiKeyPrefix("betterfly-signature", "Bearer");

            var apiInstance = new UsersApi();
            var body = new SingleSignupPayload(); // SingleSignupPayload |  (optional) 

            try
            {
                // Creates or updates an user.
                TransactionCreated result = apiInstance.UserPost(body);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling UsersApi.UserPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SingleSignupPayload**](SingleSignupPayload.md)|  | [optional] 

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="userspost"></a>
# **UsersPost**
> TransactionMultipleCreated UsersPost (byte[] file = null)

Creates or updates multiple users.

Creates or update multiple users based on the input file.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class UsersPostExample
    {
        public void main()
        {
            // Configure API key authorization: signature
            Configuration.Default.AddApiKey("betterfly-signature", "YOUR_API_KEY");
            // Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
            // Configuration.Default.AddApiKeyPrefix("betterfly-signature", "Bearer");

            var apiInstance = new UsersApi();
            var file = file_example;  // byte[] |  (optional) 

            try
            {
                // Creates or updates multiple users.
                TransactionMultipleCreated result = apiInstance.UsersPost(file);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling UsersApi.UsersPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file** | **byte[]****byte[]**|  | [optional] 

### Return type

[**TransactionMultipleCreated**](TransactionMultipleCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
