/* 
 * Hanu-Betterfly Webhooks
 *
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface ITransactionsApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get transaction by uuid.
        /// </summary>
        /// <remarks>
        /// Retrieves a transaction status by it&#x27;s uuid.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>TransactionResult</returns>
        TransactionResult TransactionGet (string uuid);

        /// <summary>
        /// Get transaction by uuid.
        /// </summary>
        /// <remarks>
        /// Retrieves a transaction status by it&#x27;s uuid.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>ApiResponse of TransactionResult</returns>
        ApiResponse<TransactionResult> TransactionGetWithHttpInfo (string uuid);
        /// <summary>
        /// Retries a transaction
        /// </summary>
        /// <remarks>
        /// Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>TransactionCreated</returns>
        TransactionCreated TransactionRetryPost (TransactionRetryBody body = null);

        /// <summary>
        /// Retries a transaction
        /// </summary>
        /// <remarks>
        /// Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>ApiResponse of TransactionCreated</returns>
        ApiResponse<TransactionCreated> TransactionRetryPostWithHttpInfo (TransactionRetryBody body = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get transaction by uuid.
        /// </summary>
        /// <remarks>
        /// Retrieves a transaction status by it&#x27;s uuid.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>Task of TransactionResult</returns>
        System.Threading.Tasks.Task<TransactionResult> TransactionGetAsync (string uuid);

        /// <summary>
        /// Get transaction by uuid.
        /// </summary>
        /// <remarks>
        /// Retrieves a transaction status by it&#x27;s uuid.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>Task of ApiResponse (TransactionResult)</returns>
        System.Threading.Tasks.Task<ApiResponse<TransactionResult>> TransactionGetAsyncWithHttpInfo (string uuid);
        /// <summary>
        /// Retries a transaction
        /// </summary>
        /// <remarks>
        /// Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of TransactionCreated</returns>
        System.Threading.Tasks.Task<TransactionCreated> TransactionRetryPostAsync (TransactionRetryBody body = null);

        /// <summary>
        /// Retries a transaction
        /// </summary>
        /// <remarks>
        /// Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of ApiResponse (TransactionCreated)</returns>
        System.Threading.Tasks.Task<ApiResponse<TransactionCreated>> TransactionRetryPostAsyncWithHttpInfo (TransactionRetryBody body = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class TransactionsApi : ITransactionsApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="TransactionsApi"/> class.
        /// </summary>
        /// <returns></returns>
        public TransactionsApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TransactionsApi"/> class
        /// </summary>
        /// <returns></returns>
        public TransactionsApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TransactionsApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public TransactionsApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get transaction by uuid. Retrieves a transaction status by it&#x27;s uuid.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>TransactionResult</returns>
        public TransactionResult TransactionGet (string uuid)
        {
             ApiResponse<TransactionResult> localVarResponse = TransactionGetWithHttpInfo(uuid);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get transaction by uuid. Retrieves a transaction status by it&#x27;s uuid.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>ApiResponse of TransactionResult</returns>
        public ApiResponse< TransactionResult > TransactionGetWithHttpInfo (string uuid)
        {
            // verify the required parameter 'uuid' is set
            if (uuid == null)
                throw new ApiException(400, "Missing required parameter 'uuid' when calling TransactionsApi->TransactionGet");

            var localVarPath = "/transaction";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (uuid != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "uuid", uuid)); // query parameter
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("TransactionGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionResult>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionResult) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionResult)));
        }

        /// <summary>
        /// Get transaction by uuid. Retrieves a transaction status by it&#x27;s uuid.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>Task of TransactionResult</returns>
        public async System.Threading.Tasks.Task<TransactionResult> TransactionGetAsync (string uuid)
        {
             ApiResponse<TransactionResult> localVarResponse = await TransactionGetAsyncWithHttpInfo(uuid);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get transaction by uuid. Retrieves a transaction status by it&#x27;s uuid.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="uuid">Transaction&#x27;s uuid</param>
        /// <returns>Task of ApiResponse (TransactionResult)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<TransactionResult>> TransactionGetAsyncWithHttpInfo (string uuid)
        {
            // verify the required parameter 'uuid' is set
            if (uuid == null)
                throw new ApiException(400, "Missing required parameter 'uuid' when calling TransactionsApi->TransactionGet");

            var localVarPath = "/transaction";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (uuid != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "uuid", uuid)); // query parameter
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("TransactionGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionResult>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionResult) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionResult)));
        }

        /// <summary>
        /// Retries a transaction Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>TransactionCreated</returns>
        public TransactionCreated TransactionRetryPost (TransactionRetryBody body = null)
        {
             ApiResponse<TransactionCreated> localVarResponse = TransactionRetryPostWithHttpInfo(body);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Retries a transaction Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>ApiResponse of TransactionCreated</returns>
        public ApiResponse< TransactionCreated > TransactionRetryPostWithHttpInfo (TransactionRetryBody body = null)
        {

            var localVarPath = "/transaction/retry";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("TransactionRetryPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionCreated>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionCreated) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionCreated)));
        }

        /// <summary>
        /// Retries a transaction Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of TransactionCreated</returns>
        public async System.Threading.Tasks.Task<TransactionCreated> TransactionRetryPostAsync (TransactionRetryBody body = null)
        {
             ApiResponse<TransactionCreated> localVarResponse = await TransactionRetryPostAsyncWithHttpInfo(body);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Retries a transaction Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of ApiResponse (TransactionCreated)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<TransactionCreated>> TransactionRetryPostAsyncWithHttpInfo (TransactionRetryBody body = null)
        {

            var localVarPath = "/transaction/retry";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("TransactionRetryPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionCreated>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionCreated) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionCreated)));
        }

    }
}
