/* 
 * Hanu-Betterfly Webhooks
 *
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface IUsersApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Creates or updates an user.
        /// </summary>
        /// <remarks>
        /// Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>TransactionCreated</returns>
        TransactionCreated UserPost (SingleSignupPayload body = null);

        /// <summary>
        /// Creates or updates an user.
        /// </summary>
        /// <remarks>
        /// Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>ApiResponse of TransactionCreated</returns>
        ApiResponse<TransactionCreated> UserPostWithHttpInfo (SingleSignupPayload body = null);
        /// <summary>
        /// Creates or updates multiple users.
        /// </summary>
        /// <remarks>
        /// Creates or update multiple users based on the input file.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>TransactionMultipleCreated</returns>
        TransactionMultipleCreated UsersPost (byte[] file = null);

        /// <summary>
        /// Creates or updates multiple users.
        /// </summary>
        /// <remarks>
        /// Creates or update multiple users based on the input file.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>ApiResponse of TransactionMultipleCreated</returns>
        ApiResponse<TransactionMultipleCreated> UsersPostWithHttpInfo (byte[] file = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Creates or updates an user.
        /// </summary>
        /// <remarks>
        /// Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of TransactionCreated</returns>
        System.Threading.Tasks.Task<TransactionCreated> UserPostAsync (SingleSignupPayload body = null);

        /// <summary>
        /// Creates or updates an user.
        /// </summary>
        /// <remarks>
        /// Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of ApiResponse (TransactionCreated)</returns>
        System.Threading.Tasks.Task<ApiResponse<TransactionCreated>> UserPostAsyncWithHttpInfo (SingleSignupPayload body = null);
        /// <summary>
        /// Creates or updates multiple users.
        /// </summary>
        /// <remarks>
        /// Creates or update multiple users based on the input file.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>Task of TransactionMultipleCreated</returns>
        System.Threading.Tasks.Task<TransactionMultipleCreated> UsersPostAsync (byte[] file = null);

        /// <summary>
        /// Creates or updates multiple users.
        /// </summary>
        /// <remarks>
        /// Creates or update multiple users based on the input file.
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>Task of ApiResponse (TransactionMultipleCreated)</returns>
        System.Threading.Tasks.Task<ApiResponse<TransactionMultipleCreated>> UsersPostAsyncWithHttpInfo (byte[] file = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class UsersApi : IUsersApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="UsersApi"/> class.
        /// </summary>
        /// <returns></returns>
        public UsersApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="UsersApi"/> class
        /// </summary>
        /// <returns></returns>
        public UsersApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="UsersApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public UsersApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Creates or updates an user. Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>TransactionCreated</returns>
        public TransactionCreated UserPost (SingleSignupPayload body = null)
        {
             ApiResponse<TransactionCreated> localVarResponse = UserPostWithHttpInfo(body);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Creates or updates an user. Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>ApiResponse of TransactionCreated</returns>
        public ApiResponse< TransactionCreated > UserPostWithHttpInfo (SingleSignupPayload body = null)
        {

            var localVarPath = "/user";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("UserPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionCreated>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionCreated) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionCreated)));
        }

        /// <summary>
        /// Creates or updates an user. Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of TransactionCreated</returns>
        public async System.Threading.Tasks.Task<TransactionCreated> UserPostAsync (SingleSignupPayload body = null)
        {
             ApiResponse<TransactionCreated> localVarResponse = await UserPostAsyncWithHttpInfo(body);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Creates or updates an user. Creates a new user. If already exists, user&#x27;s data will be updated.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body"> (optional)</param>
        /// <returns>Task of ApiResponse (TransactionCreated)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<TransactionCreated>> UserPostAsyncWithHttpInfo (SingleSignupPayload body = null)
        {

            var localVarPath = "/user";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("UserPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionCreated>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionCreated) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionCreated)));
        }

        /// <summary>
        /// Creates or updates multiple users. Creates or update multiple users based on the input file.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>TransactionMultipleCreated</returns>
        public TransactionMultipleCreated UsersPost (byte[] file = null)
        {
             ApiResponse<TransactionMultipleCreated> localVarResponse = UsersPostWithHttpInfo(file);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Creates or updates multiple users. Creates or update multiple users based on the input file.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>ApiResponse of TransactionMultipleCreated</returns>
        public ApiResponse< TransactionMultipleCreated > UsersPostWithHttpInfo (byte[] file = null)
        {

            var localVarPath = "/users";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "multipart/form-data"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (file != null) localVarFileParams.Add("file", this.Configuration.ApiClient.ParameterToFile("file", file));
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("UsersPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionMultipleCreated>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionMultipleCreated) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionMultipleCreated)));
        }

        /// <summary>
        /// Creates or updates multiple users. Creates or update multiple users based on the input file.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>Task of TransactionMultipleCreated</returns>
        public async System.Threading.Tasks.Task<TransactionMultipleCreated> UsersPostAsync (byte[] file = null)
        {
             ApiResponse<TransactionMultipleCreated> localVarResponse = await UsersPostAsyncWithHttpInfo(file);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Creates or updates multiple users. Creates or update multiple users based on the input file.
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="file"> (optional)</param>
        /// <returns>Task of ApiResponse (TransactionMultipleCreated)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<TransactionMultipleCreated>> UsersPostAsyncWithHttpInfo (byte[] file = null)
        {

            var localVarPath = "/users";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "multipart/form-data"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (file != null) localVarFileParams.Add("file", this.Configuration.ApiClient.ParameterToFile("file", file));
            // authentication (signature) required
            if (!String.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("betterfly-signature")))
            {
                localVarHeaderParams["betterfly-signature"] = this.Configuration.GetApiKeyWithPrefix("betterfly-signature");
            }

            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("UsersPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TransactionMultipleCreated>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (TransactionMultipleCreated) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TransactionMultipleCreated)));
        }

    }
}
