/* 
 * Hanu-Betterfly Webhooks
 *
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// SingleSignupPayload
    /// </summary>
    [DataContract]
        public partial class SingleSignupPayload :  IEquatable<SingleSignupPayload>, IValidatableObject
    {
        /// <summary>
        /// Event type.
        /// </summary>
        /// <value>Event type.</value>
        [JsonConverter(typeof(StringEnumConverter))]
                public enum EventEnum
        {
            /// <summary>
            /// Enum Activate for value: activate
            /// </summary>
            [EnumMember(Value = "activate")]
            Activate = 1,
            /// <summary>
            /// Enum Deactivate for value: deactivate
            /// </summary>
            [EnumMember(Value = "deactivate")]
            Deactivate = 2        }
        /// <summary>
        /// Event type.
        /// </summary>
        /// <value>Event type.</value>
        [DataMember(Name="event", EmitDefaultValue=false)]
        public EventEnum _Event { get; set; }
        /// <summary>
        /// required if event &#x3D; activate
        /// </summary>
        /// <value>required if event &#x3D; activate</value>
        [JsonConverter(typeof(StringEnumConverter))]
                public enum LocaleEnum
        {
            /// <summary>
            /// Enum En for value: en
            /// </summary>
            [EnumMember(Value = "en")]
            En = 1,
            /// <summary>
            /// Enum Es for value: es
            /// </summary>
            [EnumMember(Value = "es")]
            Es = 2,
            /// <summary>
            /// Enum Pt for value: pt
            /// </summary>
            [EnumMember(Value = "pt")]
            Pt = 3        }
        /// <summary>
        /// required if event &#x3D; activate
        /// </summary>
        /// <value>required if event &#x3D; activate</value>
        [DataMember(Name="locale", EmitDefaultValue=false)]
        public LocaleEnum? Locale { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SingleSignupPayload" /> class.
        /// </summary>
        /// <param name="_event">Event type. (required).</param>
        /// <param name="sub">user&#x27;s id (required).</param>
        /// <param name="firstName">required if event &#x3D; activate.</param>
        /// <param name="lastName">required if event &#x3D; activate.</param>
        /// <param name="maternalLastName">maternalLastName.</param>
        /// <param name="email">email (required).</param>
        /// <param name="localIdentifier">localIdentifier (required).</param>
        /// <param name="plan">plan (required).</param>
        /// <param name="locale">required if event &#x3D; activate.</param>
        public SingleSignupPayload(EventEnum _event = default(EventEnum), string sub = default(string), string firstName = default(string), string lastName = default(string), string maternalLastName = default(string), string email = default(string), SingleSignupPayloadLocalIdentifier localIdentifier = default(SingleSignupPayloadLocalIdentifier), SingleSignupPayloadPlan plan = default(SingleSignupPayloadPlan), LocaleEnum? locale = default(LocaleEnum?))
        {
            // to ensure "_event" is required (not null)
            if (_event == null)
            {
                throw new InvalidDataException("_event is a required property for SingleSignupPayload and cannot be null");
            }
            else
            {
                this._Event = _event;
            }
            // to ensure "sub" is required (not null)
            if (sub == null)
            {
                throw new InvalidDataException("sub is a required property for SingleSignupPayload and cannot be null");
            }
            else
            {
                this.Sub = sub;
            }
            // to ensure "email" is required (not null)
            if (email == null)
            {
                throw new InvalidDataException("email is a required property for SingleSignupPayload and cannot be null");
            }
            else
            {
                this.Email = email;
            }
            // to ensure "localIdentifier" is required (not null)
            if (localIdentifier == null)
            {
                throw new InvalidDataException("localIdentifier is a required property for SingleSignupPayload and cannot be null");
            }
            else
            {
                this.LocalIdentifier = localIdentifier;
            }
            // to ensure "plan" is required (not null)
            if (plan == null)
            {
                throw new InvalidDataException("plan is a required property for SingleSignupPayload and cannot be null");
            }
            else
            {
                this.Plan = plan;
            }
            this.FirstName = firstName;
            this.LastName = lastName;
            this.MaternalLastName = maternalLastName;
            this.Locale = locale;
        }
        

        /// <summary>
        /// user&#x27;s id
        /// </summary>
        /// <value>user&#x27;s id</value>
        [DataMember(Name="sub", EmitDefaultValue=false)]
        public string Sub { get; set; }

        /// <summary>
        /// required if event &#x3D; activate
        /// </summary>
        /// <value>required if event &#x3D; activate</value>
        [DataMember(Name="firstName", EmitDefaultValue=false)]
        public string FirstName { get; set; }

        /// <summary>
        /// required if event &#x3D; activate
        /// </summary>
        /// <value>required if event &#x3D; activate</value>
        [DataMember(Name="lastName", EmitDefaultValue=false)]
        public string LastName { get; set; }

        /// <summary>
        /// Gets or Sets MaternalLastName
        /// </summary>
        [DataMember(Name="maternalLastName", EmitDefaultValue=false)]
        public string MaternalLastName { get; set; }

        /// <summary>
        /// Gets or Sets Email
        /// </summary>
        [DataMember(Name="email", EmitDefaultValue=false)]
        public string Email { get; set; }

        /// <summary>
        /// Gets or Sets LocalIdentifier
        /// </summary>
        [DataMember(Name="localIdentifier", EmitDefaultValue=false)]
        public SingleSignupPayloadLocalIdentifier LocalIdentifier { get; set; }

        /// <summary>
        /// Gets or Sets Plan
        /// </summary>
        [DataMember(Name="plan", EmitDefaultValue=false)]
        public SingleSignupPayloadPlan Plan { get; set; }


        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class SingleSignupPayload {\n");
            sb.Append("  _Event: ").Append(_Event).Append("\n");
            sb.Append("  Sub: ").Append(Sub).Append("\n");
            sb.Append("  FirstName: ").Append(FirstName).Append("\n");
            sb.Append("  LastName: ").Append(LastName).Append("\n");
            sb.Append("  MaternalLastName: ").Append(MaternalLastName).Append("\n");
            sb.Append("  Email: ").Append(Email).Append("\n");
            sb.Append("  LocalIdentifier: ").Append(LocalIdentifier).Append("\n");
            sb.Append("  Plan: ").Append(Plan).Append("\n");
            sb.Append("  Locale: ").Append(Locale).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as SingleSignupPayload);
        }

        /// <summary>
        /// Returns true if SingleSignupPayload instances are equal
        /// </summary>
        /// <param name="input">Instance of SingleSignupPayload to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(SingleSignupPayload input)
        {
            if (input == null)
                return false;

            return 
                (
                    this._Event == input._Event ||
                    (this._Event != null &&
                    this._Event.Equals(input._Event))
                ) && 
                (
                    this.Sub == input.Sub ||
                    (this.Sub != null &&
                    this.Sub.Equals(input.Sub))
                ) && 
                (
                    this.FirstName == input.FirstName ||
                    (this.FirstName != null &&
                    this.FirstName.Equals(input.FirstName))
                ) && 
                (
                    this.LastName == input.LastName ||
                    (this.LastName != null &&
                    this.LastName.Equals(input.LastName))
                ) && 
                (
                    this.MaternalLastName == input.MaternalLastName ||
                    (this.MaternalLastName != null &&
                    this.MaternalLastName.Equals(input.MaternalLastName))
                ) && 
                (
                    this.Email == input.Email ||
                    (this.Email != null &&
                    this.Email.Equals(input.Email))
                ) && 
                (
                    this.LocalIdentifier == input.LocalIdentifier ||
                    (this.LocalIdentifier != null &&
                    this.LocalIdentifier.Equals(input.LocalIdentifier))
                ) && 
                (
                    this.Plan == input.Plan ||
                    (this.Plan != null &&
                    this.Plan.Equals(input.Plan))
                ) && 
                (
                    this.Locale == input.Locale ||
                    (this.Locale != null &&
                    this.Locale.Equals(input.Locale))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this._Event != null)
                    hashCode = hashCode * 59 + this._Event.GetHashCode();
                if (this.Sub != null)
                    hashCode = hashCode * 59 + this.Sub.GetHashCode();
                if (this.FirstName != null)
                    hashCode = hashCode * 59 + this.FirstName.GetHashCode();
                if (this.LastName != null)
                    hashCode = hashCode * 59 + this.LastName.GetHashCode();
                if (this.MaternalLastName != null)
                    hashCode = hashCode * 59 + this.MaternalLastName.GetHashCode();
                if (this.Email != null)
                    hashCode = hashCode * 59 + this.Email.GetHashCode();
                if (this.LocalIdentifier != null)
                    hashCode = hashCode * 59 + this.LocalIdentifier.GetHashCode();
                if (this.Plan != null)
                    hashCode = hashCode * 59 + this.Plan.GetHashCode();
                if (this.Locale != null)
                    hashCode = hashCode * 59 + this.Locale.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
