/* 
 * Hanu-Betterfly Webhooks
 *
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// TransactionCreated
    /// </summary>
    [DataContract]
        public partial class TransactionCreated :  IEquatable<TransactionCreated>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TransactionCreated" /> class.
        /// </summary>
        /// <param name="code">0 indicates that it is a sucess response.</param>
        /// <param name="message">Response message.</param>
        /// <param name="trx">Transaction UUID.</param>
        /// <param name="data">data.</param>
        public TransactionCreated(decimal? code = default(decimal?), string message = default(string), string trx = default(string), SingleSignupPayload data = default(SingleSignupPayload))
        {
            this.Code = code;
            this.Message = message;
            this.Trx = trx;
            this.Data = data;
        }
        
        /// <summary>
        /// 0 indicates that it is a sucess response
        /// </summary>
        /// <value>0 indicates that it is a sucess response</value>
        [DataMember(Name="code", EmitDefaultValue=false)]
        public decimal? Code { get; set; }

        /// <summary>
        /// Response message
        /// </summary>
        /// <value>Response message</value>
        [DataMember(Name="message", EmitDefaultValue=false)]
        public string Message { get; set; }

        /// <summary>
        /// Transaction UUID
        /// </summary>
        /// <value>Transaction UUID</value>
        [DataMember(Name="trx", EmitDefaultValue=false)]
        public string Trx { get; set; }

        /// <summary>
        /// Gets or Sets Data
        /// </summary>
        [DataMember(Name="data", EmitDefaultValue=false)]
        public SingleSignupPayload Data { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TransactionCreated {\n");
            sb.Append("  Code: ").Append(Code).Append("\n");
            sb.Append("  Message: ").Append(Message).Append("\n");
            sb.Append("  Trx: ").Append(Trx).Append("\n");
            sb.Append("  Data: ").Append(Data).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as TransactionCreated);
        }

        /// <summary>
        /// Returns true if TransactionCreated instances are equal
        /// </summary>
        /// <param name="input">Instance of TransactionCreated to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TransactionCreated input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Code == input.Code ||
                    (this.Code != null &&
                    this.Code.Equals(input.Code))
                ) && 
                (
                    this.Message == input.Message ||
                    (this.Message != null &&
                    this.Message.Equals(input.Message))
                ) && 
                (
                    this.Trx == input.Trx ||
                    (this.Trx != null &&
                    this.Trx.Equals(input.Trx))
                ) && 
                (
                    this.Data == input.Data ||
                    (this.Data != null &&
                    this.Data.Equals(input.Data))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Code != null)
                    hashCode = hashCode * 59 + this.Code.GetHashCode();
                if (this.Message != null)
                    hashCode = hashCode * 59 + this.Message.GetHashCode();
                if (this.Trx != null)
                    hashCode = hashCode * 59 + this.Trx.GetHashCode();
                if (this.Data != null)
                    hashCode = hashCode * 59 + this.Data.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
