/* 
 * Hanu-Betterfly Webhooks
 *
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// TransactionResult
    /// </summary>
    [DataContract]
        public partial class TransactionResult :  IEquatable<TransactionResult>, IValidatableObject
    {
        /// <summary>
        /// added to single user transactions only
        /// </summary>
        /// <value>added to single user transactions only</value>
        [JsonConverter(typeof(StringEnumConverter))]
                public enum EventEnum
        {
            /// <summary>
            /// Enum Activate for value: activate
            /// </summary>
            [EnumMember(Value = "activate")]
            Activate = 1,
            /// <summary>
            /// Enum Deactivate for value: deactivate
            /// </summary>
            [EnumMember(Value = "deactivate")]
            Deactivate = 2        }
        /// <summary>
        /// added to single user transactions only
        /// </summary>
        /// <value>added to single user transactions only</value>
        [DataMember(Name="event", EmitDefaultValue=false)]
        public EventEnum? _Event { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TransactionResult" /> class.
        /// </summary>
        /// <param name="trx">trx.</param>
        /// <param name="_event">added to single user transactions only.</param>
        /// <param name="result">Transaction result, true &#x3D; success..</param>
        /// <param name="message">Response&#x27;s additional info.</param>
        public TransactionResult(string trx = default(string), EventEnum? _event = default(EventEnum?), bool? result = default(bool?), string message = default(string))
        {
            this.Trx = trx;
            this._Event = _event;
            this.Result = result;
            this.Message = message;
        }
        
        /// <summary>
        /// Gets or Sets Trx
        /// </summary>
        [DataMember(Name="trx", EmitDefaultValue=false)]
        public string Trx { get; set; }


        /// <summary>
        /// Transaction result, true &#x3D; success.
        /// </summary>
        /// <value>Transaction result, true &#x3D; success.</value>
        [DataMember(Name="result", EmitDefaultValue=false)]
        public bool? Result { get; set; }

        /// <summary>
        /// Response&#x27;s additional info
        /// </summary>
        /// <value>Response&#x27;s additional info</value>
        [DataMember(Name="message", EmitDefaultValue=false)]
        public string Message { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TransactionResult {\n");
            sb.Append("  Trx: ").Append(Trx).Append("\n");
            sb.Append("  _Event: ").Append(_Event).Append("\n");
            sb.Append("  Result: ").Append(Result).Append("\n");
            sb.Append("  Message: ").Append(Message).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as TransactionResult);
        }

        /// <summary>
        /// Returns true if TransactionResult instances are equal
        /// </summary>
        /// <param name="input">Instance of TransactionResult to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TransactionResult input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Trx == input.Trx ||
                    (this.Trx != null &&
                    this.Trx.Equals(input.Trx))
                ) && 
                (
                    this._Event == input._Event ||
                    (this._Event != null &&
                    this._Event.Equals(input._Event))
                ) && 
                (
                    this.Result == input.Result ||
                    (this.Result != null &&
                    this.Result.Equals(input.Result))
                ) && 
                (
                    this.Message == input.Message ||
                    (this.Message != null &&
                    this.Message.Equals(input.Message))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Trx != null)
                    hashCode = hashCode * 59 + this.Trx.GetHashCode();
                if (this._Event != null)
                    hashCode = hashCode * 59 + this._Event.GetHashCode();
                if (this.Result != null)
                    hashCode = hashCode * 59 + this.Result.GetHashCode();
                if (this.Message != null)
                    hashCode = hashCode * 59 + this.Message.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
