# Go API client for swagger

Hanu-Betterfly webhooks endpoints documentation.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0-oas3
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TransactionsApi* | [**TransactionGet**](docs/TransactionsApi.md#transactionget) | **Get** /transaction | Get transaction by uuid.
*TransactionsApi* | [**TransactionRetryPost**](docs/TransactionsApi.md#transactionretrypost) | **Post** /transaction/retry | Retries a transaction
*UsersApi* | [**UserPost**](docs/UsersApi.md#userpost) | **Post** /user | Creates or updates an user.
*UsersApi* | [**UsersPost**](docs/UsersApi.md#userspost) | **Post** /users | Creates or updates multiple users.

## Documentation For Models

 - [ResponseUnauthorized](docs/ResponseUnauthorized.md)
 - [ResponseUnhandled](docs/ResponseUnhandled.md)
 - [SingleSignupPayload](docs/SingleSignupPayload.md)
 - [SingleSignupPayloadLocalIdentifier](docs/SingleSignupPayloadLocalIdentifier.md)
 - [SingleSignupPayloadPlan](docs/SingleSignupPayloadPlan.md)
 - [TransactionCreated](docs/TransactionCreated.md)
 - [TransactionMultipleCreated](docs/TransactionMultipleCreated.md)
 - [TransactionNotFound](docs/TransactionNotFound.md)
 - [TransactionResult](docs/TransactionResult.md)
 - [TransactionRetryBody](docs/TransactionRetryBody.md)
 - [UsersBody](docs/UsersBody.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorData](docs/ValidationErrorData.md)
 - [ValidationErrorDataErrors](docs/ValidationErrorDataErrors.md)
 - [ValidationErrorDataErrorsFiedName](docs/ValidationErrorDataErrorsFiedName.md)

## Documentation For Authorization

## signature
- **Type**: API key 

Example
```golang
auth := context.WithValue(context.Background(), sw.ContextAPIKey, sw.APIKey{
	Key: "APIKEY",
	Prefix: "Bearer", // Omit if not necessary.
})
r, err := client.Service.Operation(auth, args)
```

## Author


