# swagger-java-client

Hanu-Betterfly Webhooks
- API version: 1.0.0-oas3
  - Build date: 2023-03-08T23:29:44.105575624Z[GMT]

Hanu-Betterfly webhooks endpoints documentation.


*Automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen)*


## Requirements

Building the API client library requires:
1. Java 1.7+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>io.swagger</groupId>
  <artifactId>swagger-java-client</artifactId>
  <version>1.0.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "io.swagger:swagger-java-client:1.0.0"
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

* `target/swagger-java-client-1.0.0.jar`
* `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java
import io.swagger.client.*;
import io.swagger.client.auth.*;
import io.swagger.client.model.*;
import io.swagger.client.api.TransactionsApi;

import java.io.File;
import java.util.*;

public class TransactionsApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();

        // Configure API key authorization: signature
        ApiKeyAuth signature = (ApiKeyAuth) defaultClient.getAuthentication("signature");
        signature.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //signature.setApiKeyPrefix("Token");

        TransactionsApi apiInstance = new TransactionsApi();
        String uuid = "uuid_example"; // String | Transaction's uuid
        try {
            TransactionResult result = apiInstance.transactionGet(uuid);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TransactionsApi#transactionGet");
            e.printStackTrace();
        }
    }
}
import io.swagger.client.*;
import io.swagger.client.auth.*;
import io.swagger.client.model.*;
import io.swagger.client.api.TransactionsApi;

import java.io.File;
import java.util.*;

public class TransactionsApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();

        // Configure API key authorization: signature
        ApiKeyAuth signature = (ApiKeyAuth) defaultClient.getAuthentication("signature");
        signature.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //signature.setApiKeyPrefix("Token");

        TransactionsApi apiInstance = new TransactionsApi();
        TransactionRetryBody body = new TransactionRetryBody(); // TransactionRetryBody | 
        try {
            TransactionCreated result = apiInstance.transactionRetryPost(body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TransactionsApi#transactionRetryPost");
            e.printStackTrace();
        }
    }
}
```

## Documentation for API Endpoints

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TransactionsApi* | [**transactionGet**](docs/TransactionsApi.md#transactionGet) | **GET** /transaction | Get transaction by uuid.
*TransactionsApi* | [**transactionRetryPost**](docs/TransactionsApi.md#transactionRetryPost) | **POST** /transaction/retry | Retries a transaction
*UsersApi* | [**userPost**](docs/UsersApi.md#userPost) | **POST** /user | Creates or updates an user.
*UsersApi* | [**usersPost**](docs/UsersApi.md#usersPost) | **POST** /users | Creates or updates multiple users.

## Documentation for Models

 - [ResponseUnauthorized](docs/ResponseUnauthorized.md)
 - [ResponseUnhandled](docs/ResponseUnhandled.md)
 - [SingleSignupPayload](docs/SingleSignupPayload.md)
 - [SingleSignupPayloadLocalIdentifier](docs/SingleSignupPayloadLocalIdentifier.md)
 - [SingleSignupPayloadPlan](docs/SingleSignupPayloadPlan.md)
 - [TransactionCreated](docs/TransactionCreated.md)
 - [TransactionMultipleCreated](docs/TransactionMultipleCreated.md)
 - [TransactionNotFound](docs/TransactionNotFound.md)
 - [TransactionResult](docs/TransactionResult.md)
 - [TransactionRetryBody](docs/TransactionRetryBody.md)
 - [UsersBody](docs/UsersBody.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorData](docs/ValidationErrorData.md)
 - [ValidationErrorDataErrors](docs/ValidationErrorDataErrors.md)
 - [ValidationErrorDataErrorsFiedName](docs/ValidationErrorDataErrorsFiedName.md)

## Documentation for Authorization

Authentication schemes defined for the API:
### signature

- **Type**: API key
- **API key parameter name**: betterfly-signature
- **Location**: HTTP header


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author


