# TransactionsApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**transactionGet**](TransactionsApi.md#transactionGet) | **GET** /transaction | Get transaction by uuid.
[**transactionRetryPost**](TransactionsApi.md#transactionRetryPost) | **POST** /transaction/retry | Retries a transaction

<a name="transactionGet"></a>
# **transactionGet**
> TransactionResult transactionGet(uuid)

Get transaction by uuid.

Retrieves a transaction status by it&#x27;s uuid.

### Example
```java
// Import classes:
//import io.swagger.client.ApiClient;
//import io.swagger.client.ApiException;
//import io.swagger.client.Configuration;
//import io.swagger.client.auth.*;
//import io.swagger.client.api.TransactionsApi;

ApiClient defaultClient = Configuration.getDefaultApiClient();

// Configure API key authorization: signature
ApiKeyAuth signature = (ApiKeyAuth) defaultClient.getAuthentication("signature");
signature.setApiKey("YOUR API KEY");
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//signature.setApiKeyPrefix("Token");

TransactionsApi apiInstance = new TransactionsApi();
String uuid = "uuid_example"; // String | Transaction's uuid
try {
    TransactionResult result = apiInstance.transactionGet(uuid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling TransactionsApi#transactionGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uuid** | **String**| Transaction&#x27;s uuid |

### Return type

[**TransactionResult**](TransactionResult.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="transactionRetryPost"></a>
# **transactionRetryPost**
> TransactionCreated transactionRetryPost(body)

Retries a transaction

Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.

### Example
```java
// Import classes:
//import io.swagger.client.ApiClient;
//import io.swagger.client.ApiException;
//import io.swagger.client.Configuration;
//import io.swagger.client.auth.*;
//import io.swagger.client.api.TransactionsApi;

ApiClient defaultClient = Configuration.getDefaultApiClient();

// Configure API key authorization: signature
ApiKeyAuth signature = (ApiKeyAuth) defaultClient.getAuthentication("signature");
signature.setApiKey("YOUR API KEY");
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//signature.setApiKeyPrefix("Token");

TransactionsApi apiInstance = new TransactionsApi();
TransactionRetryBody body = new TransactionRetryBody(); // TransactionRetryBody | 
try {
    TransactionCreated result = apiInstance.transactionRetryPost(body);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling TransactionsApi#transactionRetryPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**TransactionRetryBody**](TransactionRetryBody.md)|  | [optional]

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

