# UsersApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**userPost**](UsersApi.md#userPost) | **POST** /user | Creates or updates an user.
[**usersPost**](UsersApi.md#usersPost) | **POST** /users | Creates or updates multiple users.

<a name="userPost"></a>
# **userPost**
> TransactionCreated userPost(body)

Creates or updates an user.

Creates a new user. If already exists, user&#x27;s data will be updated.

### Example
```java
// Import classes:
//import io.swagger.client.ApiClient;
//import io.swagger.client.ApiException;
//import io.swagger.client.Configuration;
//import io.swagger.client.auth.*;
//import io.swagger.client.api.UsersApi;

ApiClient defaultClient = Configuration.getDefaultApiClient();

// Configure API key authorization: signature
ApiKeyAuth signature = (ApiKeyAuth) defaultClient.getAuthentication("signature");
signature.setApiKey("YOUR API KEY");
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//signature.setApiKeyPrefix("Token");

UsersApi apiInstance = new UsersApi();
SingleSignupPayload body = new SingleSignupPayload(); // SingleSignupPayload | 
try {
    TransactionCreated result = apiInstance.userPost(body);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UsersApi#userPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SingleSignupPayload**](SingleSignupPayload.md)|  | [optional]

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="usersPost"></a>
# **usersPost**
> TransactionMultipleCreated usersPost(file)

Creates or updates multiple users.

Creates or update multiple users based on the input file.

### Example
```java
// Import classes:
//import io.swagger.client.ApiClient;
//import io.swagger.client.ApiException;
//import io.swagger.client.Configuration;
//import io.swagger.client.auth.*;
//import io.swagger.client.api.UsersApi;

ApiClient defaultClient = Configuration.getDefaultApiClient();

// Configure API key authorization: signature
ApiKeyAuth signature = (ApiKeyAuth) defaultClient.getAuthentication("signature");
signature.setApiKey("YOUR API KEY");
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//signature.setApiKeyPrefix("Token");

UsersApi apiInstance = new UsersApi();
File file = new File("file_example"); // File | 
try {
    TransactionMultipleCreated result = apiInstance.usersPost(file);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UsersApi#usersPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file** | **File**|  | [optional]

### Return type

[**TransactionMultipleCreated**](TransactionMultipleCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

