# io.swagger.client - Kotlin client library for Hanu-Betterfly Webhooks

## Requires

* Kotlin 1.4.30
* Gradle 5.3

## Build

First, create the gradle wrapper script:

```
gradle wrapper
```

Then, run:

```
./gradlew check assemble
```

This runs all tests and packages the library.

## Features/Implementation Notes

* Supports JSON inputs/outputs, File inputs, and Form inputs.
* Supports collection formats for query parameters: csv, tsv, ssv, pipes.
* Some Kotlin and Java types are fully qualified to avoid conflicts with types defined in Swagger definitions.
* Implementation of ApiClient is intended to reduce method counts, specifically to benefit Android targets.

<a name="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TransactionsApi* | [**transactionGet**](docs/TransactionsApi.md#transactionget) | **GET** /transaction | Get transaction by uuid.
*TransactionsApi* | [**transactionRetryPost**](docs/TransactionsApi.md#transactionretrypost) | **POST** /transaction/retry | Retries a transaction
*UsersApi* | [**userPost**](docs/UsersApi.md#userpost) | **POST** /user | Creates or updates an user.
*UsersApi* | [**usersPost**](docs/UsersApi.md#userspost) | **POST** /users | Creates or updates multiple users.

<a name="documentation-for-models"></a>
## Documentation for Models

 - [io.swagger.client.models.ResponseUnauthorized](docs/ResponseUnauthorized.md)
 - [io.swagger.client.models.ResponseUnhandled](docs/ResponseUnhandled.md)
 - [io.swagger.client.models.SingleSignupPayload](docs/SingleSignupPayload.md)
 - [io.swagger.client.models.SingleSignupPayloadLocalIdentifier](docs/SingleSignupPayloadLocalIdentifier.md)
 - [io.swagger.client.models.SingleSignupPayloadPlan](docs/SingleSignupPayloadPlan.md)
 - [io.swagger.client.models.TransactionCreated](docs/TransactionCreated.md)
 - [io.swagger.client.models.TransactionMultipleCreated](docs/TransactionMultipleCreated.md)
 - [io.swagger.client.models.TransactionNotFound](docs/TransactionNotFound.md)
 - [io.swagger.client.models.TransactionResult](docs/TransactionResult.md)
 - [io.swagger.client.models.TransactionRetryBody](docs/TransactionRetryBody.md)
 - [io.swagger.client.models.UsersBody](docs/UsersBody.md)
 - [io.swagger.client.models.ValidationError](docs/ValidationError.md)
 - [io.swagger.client.models.ValidationErrorData](docs/ValidationErrorData.md)
 - [io.swagger.client.models.ValidationErrorDataErrors](docs/ValidationErrorDataErrors.md)
 - [io.swagger.client.models.ValidationErrorDataErrorsFiedName](docs/ValidationErrorDataErrorsFiedName.md)

<a name="documentation-for-authorization"></a>
## Documentation for Authorization

<a name="signature"></a>
### signature


