# TransactionsApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**transactionGet**](TransactionsApi.md#transactionGet) | **GET** /transaction | Get transaction by uuid.
[**transactionRetryPost**](TransactionsApi.md#transactionRetryPost) | **POST** /transaction/retry | Retries a transaction

<a name="transactionGet"></a>
# **transactionGet**
> TransactionResult transactionGet(uuid)

Get transaction by uuid.

Retrieves a transaction status by it&#x27;s uuid.

### Example
```kotlin
// Import classes:
//import io.swagger.client.infrastructure.*
//import io.swagger.client.models.*;

val apiInstance = TransactionsApi()
val uuid : kotlin.String = uuid_example // kotlin.String | Transaction's uuid
try {
    val result : TransactionResult = apiInstance.transactionGet(uuid)
    println(result)
} catch (e: ClientException) {
    println("4xx response calling TransactionsApi#transactionGet")
    e.printStackTrace()
} catch (e: ServerException) {
    println("5xx response calling TransactionsApi#transactionGet")
    e.printStackTrace()
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uuid** | **kotlin.String**| Transaction&#x27;s uuid |

### Return type

[**TransactionResult**](TransactionResult.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="transactionRetryPost"></a>
# **transactionRetryPost**
> TransactionCreated transactionRetryPost(body)

Retries a transaction

Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.

### Example
```kotlin
// Import classes:
//import io.swagger.client.infrastructure.*
//import io.swagger.client.models.*;

val apiInstance = TransactionsApi()
val body : TransactionRetryBody =  // TransactionRetryBody | 
try {
    val result : TransactionCreated = apiInstance.transactionRetryPost(body)
    println(result)
} catch (e: ClientException) {
    println("4xx response calling TransactionsApi#transactionRetryPost")
    e.printStackTrace()
} catch (e: ServerException) {
    println("5xx response calling TransactionsApi#transactionRetryPost")
    e.printStackTrace()
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**TransactionRetryBody**](TransactionRetryBody.md)|  | [optional]

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

