# UsersApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**userPost**](UsersApi.md#userPost) | **POST** /user | Creates or updates an user.
[**usersPost**](UsersApi.md#usersPost) | **POST** /users | Creates or updates multiple users.

<a name="userPost"></a>
# **userPost**
> TransactionCreated userPost(body)

Creates or updates an user.

Creates a new user. If already exists, user&#x27;s data will be updated.

### Example
```kotlin
// Import classes:
//import io.swagger.client.infrastructure.*
//import io.swagger.client.models.*;

val apiInstance = UsersApi()
val body : SingleSignupPayload =  // SingleSignupPayload | 
try {
    val result : TransactionCreated = apiInstance.userPost(body)
    println(result)
} catch (e: ClientException) {
    println("4xx response calling UsersApi#userPost")
    e.printStackTrace()
} catch (e: ServerException) {
    println("5xx response calling UsersApi#userPost")
    e.printStackTrace()
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SingleSignupPayload**](SingleSignupPayload.md)|  | [optional]

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="usersPost"></a>
# **usersPost**
> TransactionMultipleCreated usersPost(file)

Creates or updates multiple users.

Creates or update multiple users based on the input file.

### Example
```kotlin
// Import classes:
//import io.swagger.client.infrastructure.*
//import io.swagger.client.models.*;

val apiInstance = UsersApi()
val file : kotlin.Array<kotlin.Byte> = file_example // kotlin.Array<kotlin.Byte> | 
try {
    val result : TransactionMultipleCreated = apiInstance.usersPost(file)
    println(result)
} catch (e: ClientException) {
    println("4xx response calling UsersApi#usersPost")
    e.printStackTrace()
} catch (e: ServerException) {
    println("5xx response calling UsersApi#usersPost")
    e.printStackTrace()
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file** | **kotlin.Array&lt;kotlin.Byte&gt;**|  | [optional]

### Return type

[**TransactionMultipleCreated**](TransactionMultipleCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

