/**
 * Hanu-Betterfly Webhooks
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */
package io.swagger.client.apis

import io.swagger.client.models.ResponseUnauthorized
import io.swagger.client.models.ResponseUnhandled
import io.swagger.client.models.TransactionCreated
import io.swagger.client.models.TransactionNotFound
import io.swagger.client.models.TransactionResult
import io.swagger.client.models.TransactionRetryBody
import io.swagger.client.models.ValidationError

import io.swagger.client.infrastructure.*

class TransactionsApi(basePath: kotlin.String = "https://dev.hanufit.com:8080/v1/partners/betterfly") : ApiClient(basePath) {

    /**
     * Get transaction by uuid.
     * Retrieves a transaction status by it&#x27;s uuid.
     * @param uuid Transaction&#x27;s uuid 
     * @return TransactionResult
     */
    @Suppress("UNCHECKED_CAST")
    fun transactionGet(uuid: kotlin.String): TransactionResult {
        val localVariableQuery: MultiValueMap = mapOf("uuid" to listOf("$uuid"))
        val localVariableConfig = RequestConfig(
                RequestMethod.GET,
                "/transaction", query = localVariableQuery
        )
        val response = request<TransactionResult>(
                localVariableConfig
        )

        return when (response.responseType) {
            ResponseType.Success -> (response as Success<*>).data as TransactionResult
            ResponseType.Informational -> TODO()
            ResponseType.Redirection -> TODO()
            ResponseType.ClientError -> throw ClientException((response as ClientError<*>).body as? String ?: "Client error")
            ResponseType.ServerError -> throw ServerException((response as ServerError<*>).message ?: "Server error")
        }
    }
    /**
     * Retries a transaction
     * Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
     * @param body  (optional)
     * @return TransactionCreated
     */
    @Suppress("UNCHECKED_CAST")
    fun transactionRetryPost(body: TransactionRetryBody? = null): TransactionCreated {
        val localVariableBody: kotlin.Any? = body
        
        val localVariableConfig = RequestConfig(
                RequestMethod.POST,
                "/transaction/retry"
        )
        val response = request<TransactionCreated>(
                localVariableConfig, localVariableBody
        )

        return when (response.responseType) {
            ResponseType.Success -> (response as Success<*>).data as TransactionCreated
            ResponseType.Informational -> TODO()
            ResponseType.Redirection -> TODO()
            ResponseType.ClientError -> throw ClientException((response as ClientError<*>).body as? String ?: "Client error")
            ResponseType.ServerError -> throw ServerException((response as ServerError<*>).message ?: "Server error")
        }
    }
}
