# swagger-client
Hanu-Betterfly webhooks endpoints documentation.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0-oas3
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: signature
configuration = swagger_client.Configuration()
configuration.api_key['betterfly-signature'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['betterfly-signature'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.TransactionsApi(swagger_client.ApiClient(configuration))
uuid = 'uuid_example' # str | Transaction's uuid

try:
    # Get transaction by uuid.
    api_response = api_instance.transaction_get(uuid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling TransactionsApi->transaction_get: %s\n" % e)

# Configure API key authorization: signature
configuration = swagger_client.Configuration()
configuration.api_key['betterfly-signature'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['betterfly-signature'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.TransactionsApi(swagger_client.ApiClient(configuration))
body = swagger_client.TransactionRetryBody() # TransactionRetryBody |  (optional)

try:
    # Retries a transaction
    api_response = api_instance.transaction_retry_post(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling TransactionsApi->transaction_retry_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TransactionsApi* | [**transaction_get**](docs/TransactionsApi.md#transaction_get) | **GET** /transaction | Get transaction by uuid.
*TransactionsApi* | [**transaction_retry_post**](docs/TransactionsApi.md#transaction_retry_post) | **POST** /transaction/retry | Retries a transaction
*UsersApi* | [**user_post**](docs/UsersApi.md#user_post) | **POST** /user | Creates or updates an user.
*UsersApi* | [**users_post**](docs/UsersApi.md#users_post) | **POST** /users | Creates or updates multiple users.

## Documentation For Models

 - [ResponseUnauthorized](docs/ResponseUnauthorized.md)
 - [ResponseUnhandled](docs/ResponseUnhandled.md)
 - [SingleSignupPayload](docs/SingleSignupPayload.md)
 - [SingleSignupPayloadLocalIdentifier](docs/SingleSignupPayloadLocalIdentifier.md)
 - [SingleSignupPayloadPlan](docs/SingleSignupPayloadPlan.md)
 - [TransactionCreated](docs/TransactionCreated.md)
 - [TransactionMultipleCreated](docs/TransactionMultipleCreated.md)
 - [TransactionNotFound](docs/TransactionNotFound.md)
 - [TransactionResult](docs/TransactionResult.md)
 - [TransactionRetryBody](docs/TransactionRetryBody.md)
 - [UsersBody](docs/UsersBody.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorData](docs/ValidationErrorData.md)
 - [ValidationErrorDataErrors](docs/ValidationErrorDataErrors.md)
 - [ValidationErrorDataErrorsFiedName](docs/ValidationErrorDataErrorsFiedName.md)

## Documentation For Authorization


## signature

- **Type**: API key
- **API key parameter name**: betterfly-signature
- **Location**: HTTP header


## Author


