# swagger_client.TransactionsApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**transaction_get**](TransactionsApi.md#transaction_get) | **GET** /transaction | Get transaction by uuid.
[**transaction_retry_post**](TransactionsApi.md#transaction_retry_post) | **POST** /transaction/retry | Retries a transaction

# **transaction_get**
> TransactionResult transaction_get(uuid)

Get transaction by uuid.

Retrieves a transaction status by it's uuid.

### Example
```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: signature
configuration = swagger_client.Configuration()
configuration.api_key['betterfly-signature'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['betterfly-signature'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.TransactionsApi(swagger_client.ApiClient(configuration))
uuid = 'uuid_example' # str | Transaction's uuid

try:
    # Get transaction by uuid.
    api_response = api_instance.transaction_get(uuid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling TransactionsApi->transaction_get: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uuid** | **str**| Transaction&#x27;s uuid | 

### Return type

[**TransactionResult**](TransactionResult.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **transaction_retry_post**
> TransactionCreated transaction_retry_post(body=body)

Retries a transaction

Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.

### Example
```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: signature
configuration = swagger_client.Configuration()
configuration.api_key['betterfly-signature'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['betterfly-signature'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.TransactionsApi(swagger_client.ApiClient(configuration))
body = swagger_client.TransactionRetryBody() # TransactionRetryBody |  (optional)

try:
    # Retries a transaction
    api_response = api_instance.transaction_retry_post(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling TransactionsApi->transaction_retry_post: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**TransactionRetryBody**](TransactionRetryBody.md)|  | [optional] 

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

