# swagger_client.UsersApi

All URIs are relative to *https://dev.hanufit.com:8080/v1/partners/betterfly*

Method | HTTP request | Description
------------- | ------------- | -------------
[**user_post**](UsersApi.md#user_post) | **POST** /user | Creates or updates an user.
[**users_post**](UsersApi.md#users_post) | **POST** /users | Creates or updates multiple users.

# **user_post**
> TransactionCreated user_post(body=body)

Creates or updates an user.

Creates a new user. If already exists, user's data will be updated.

### Example
```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: signature
configuration = swagger_client.Configuration()
configuration.api_key['betterfly-signature'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['betterfly-signature'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.UsersApi(swagger_client.ApiClient(configuration))
body = swagger_client.SingleSignupPayload() # SingleSignupPayload |  (optional)

try:
    # Creates or updates an user.
    api_response = api_instance.user_post(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling UsersApi->user_post: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SingleSignupPayload**](SingleSignupPayload.md)|  | [optional] 

### Return type

[**TransactionCreated**](TransactionCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **users_post**
> TransactionMultipleCreated users_post(file=file)

Creates or updates multiple users.

Creates or update multiple users based on the input file.

### Example
```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: signature
configuration = swagger_client.Configuration()
configuration.api_key['betterfly-signature'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['betterfly-signature'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.UsersApi(swagger_client.ApiClient(configuration))
file = 'file_example' # str |  (optional)

try:
    # Creates or updates multiple users.
    api_response = api_instance.users_post(file=file)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling UsersApi->users_post: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file** | **str**|  | [optional] 

### Return type

[**TransactionMultipleCreated**](TransactionMultipleCreated.md)

### Authorization

[signature](../README.md#signature)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

