//
// UsersAPI.swift
//
// Generated by swagger-codegen
// https://github.com/swagger-api/swagger-codegen
//

import Foundation
import Alamofire



open class UsersAPI {
    /**
     Creates or updates an user.
     - parameter body: (body)  (optional)
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func userPost(body: SingleSignupPayload? = nil, completion: @escaping ((_ data: TransactionCreated?,_ error: Error?) -> Void)) {
        userPostWithRequestBuilder(body: body).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }


    /**
     Creates or updates an user.
     - POST /user
     - Creates a new user. If already exists, user's data will be updated.
     - API Key:
       - type: apiKey betterfly-signature 
       - name: signature
     - examples: [{contentType=application/json, example={
  "code" : 0,
  "data" : {
    "maternalLastName" : "Ade",
    "sub" : "123",
    "firstName" : "John",
    "lastName" : "Lemon",
    "localIdentifier" : {
      "idType" : "cpf",
      "idValue" : "35032029855",
      "idTypeId" : 2
    },
    "event" : "activate",
    "locale" : "en",
    "plan" : {
      "id" : 3,
      "startDate" : "2021-12-01"
    },
    "email" : "johnlemon@fru.it"
  },
  "trx" : "737be7f6-c3a2-4f72-ad85-3b9072b12fbe",
  "message" : "OK"
}}]
     - parameter body: (body)  (optional)

     - returns: RequestBuilder<TransactionCreated> 
     */
    open class func userPostWithRequestBuilder(body: SingleSignupPayload? = nil) -> RequestBuilder<TransactionCreated> {
        let path = "/user"
        let URLString = SwaggerClientAPI.basePath + path
        let parameters = JSONEncodingHelper.encodingParameters(forEncodableObject: body)

        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<TransactionCreated>.Type = SwaggerClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "POST", URLString: (url?.string ?? URLString), parameters: parameters, isBody: true)
    }

    /**
     Creates or updates multiple users.
     - parameter file: (form)  (optional)
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func usersPost(file: Data? = nil, completion: @escaping ((_ data: TransactionMultipleCreated?,_ error: Error?) -> Void)) {
        usersPostWithRequestBuilder(file: file).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }


    /**
     Creates or updates multiple users.
     - POST /users
     - Creates or update multiple users based on the input file.
     - API Key:
       - type: apiKey betterfly-signature 
       - name: signature
     - examples: [{contentType=application/json, example={
  "code" : 0,
  "data" : { },
  "trx" : "737be7f6-c3a2-4f72-ad85-3b9072b12fbe",
  "message" : "OK"
}}]
     - parameter file: (form)  (optional)

     - returns: RequestBuilder<TransactionMultipleCreated> 
     */
    open class func usersPostWithRequestBuilder(file: Data? = nil) -> RequestBuilder<TransactionMultipleCreated> {
        let path = "/users"
        let URLString = SwaggerClientAPI.basePath + path
        let formParams: [String:Any?] = [
                        "file": file
        ]

        let nonNullParameters = APIHelper.rejectNil(formParams)
        let parameters = APIHelper.convertBoolToString(nonNullParameters)

        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<TransactionMultipleCreated>.Type = SwaggerClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "POST", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }

}
