//
// TransactionsAPI.swift
//
// Generated by swagger-codegen
// https://github.com/swagger-api/swagger-codegen
//

import Foundation
import Alamofire


open class TransactionsAPI {
    /**
     Get transaction by uuid.

     - parameter uuid: (query) Transaction&#x27;s uuid 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func transactionGet(uuid: String, completion: @escaping ((_ data: TransactionResult?,_ error: Error?) -> Void)) {
        transactionGetWithRequestBuilder(uuid: uuid).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }


    /**
     Get transaction by uuid.
     - GET /transaction

     - API Key:
       - type: apiKey betterfly-signature 
       - name: signature
     - examples: [{contentType=application/json, example={
  "result" : true,
  "trx" : "737be7f6-c3a2-4f72-ad85-3b9072b12fbe",
  "event" : "activate",
  "message" : "message"
}}]
     - parameter uuid: (query) Transaction&#x27;s uuid 

     - returns: RequestBuilder<TransactionResult> 
     */
    open class func transactionGetWithRequestBuilder(uuid: String) -> RequestBuilder<TransactionResult> {
        let path = "/transaction"
        let URLString = SwaggerClientAPI.basePath + path
        let parameters: [String:Any]? = nil
        var url = URLComponents(string: URLString)
        url?.queryItems = APIHelper.mapValuesToQueryItems([
                        "uuid": uuid
        ])


        let requestBuilder: RequestBuilder<TransactionResult>.Type = SwaggerClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "GET", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }
    /**
     Retries a transaction

     - parameter body: (body)  (optional)
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func transactionRetryPost(body: TransactionRetryBody? = nil, completion: @escaping ((_ data: TransactionCreated?,_ error: Error?) -> Void)) {
        transactionRetryPostWithRequestBuilder(body: body).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }


    /**
     Retries a transaction
     - POST /transaction/retry

     - API Key:
       - type: apiKey betterfly-signature 
       - name: signature
     - examples: [{contentType=application/json, example={
  "code" : 0,
  "data" : {
    "maternalLastName" : "Ade",
    "sub" : "123",
    "firstName" : "John",
    "lastName" : "Lemon",
    "localIdentifier" : {
      "idType" : "cpf",
      "idValue" : "35032029855",
      "idTypeId" : 2
    },
    "event" : "activate",
    "locale" : "en",
    "plan" : {
      "id" : 3,
      "startDate" : "2021-12-01"
    },
    "email" : "johnlemon@fru.it"
  },
  "trx" : "737be7f6-c3a2-4f72-ad85-3b9072b12fbe",
  "message" : "OK"
}}]
     - parameter body: (body)  (optional)

     - returns: RequestBuilder<TransactionCreated> 
     */
    open class func transactionRetryPostWithRequestBuilder(body: TransactionRetryBody? = nil) -> RequestBuilder<TransactionCreated> {
        let path = "/transaction/retry"
        let URLString = SwaggerClientAPI.basePath + path
        let parameters = JSONEncodingHelper.encodingParameters(forEncodableObject: body)
        let url = URLComponents(string: URLString)


        let requestBuilder: RequestBuilder<TransactionCreated>.Type = SwaggerClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "POST", URLString: (url?.string ?? URLString), parameters: parameters, isBody: true)
    }
}
