/// <reference path="./custom.d.ts" />
// tslint:disable
/**
 * Hanu-Betterfly Webhooks
 * Hanu-Betterfly webhooks endpoints documentation.
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 *
 * NOTE: This file is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the file manually.
 */

import * as url from "url";
import * as isomorphicFetch from "isomorphic-fetch";
import { Configuration } from "./configuration";

const BASE_PATH = "https://dev.hanufit.com:8080/v1/partners/betterfly".replace(/\/+$/, "");

/**
 *
 * @export
 */
export const COLLECTION_FORMATS = {
    csv: ",",
    ssv: " ",
    tsv: "\t",
    pipes: "|",
};

/**
 *
 * @export
 * @interface FetchAPI
 */
export interface FetchAPI {
    (url: string, init?: any): Promise<Response>;
}

/**
 *
 * @export
 * @interface FetchArgs
 */
export interface FetchArgs {
    url: string;
    options: any;
}

/**
 *
 * @export
 * @class BaseAPI
 */
export class BaseAPI {
    protected configuration: Configuration;

    constructor(configuration?: Configuration, protected basePath: string = BASE_PATH, protected fetch: FetchAPI = isomorphicFetch) {
        if (configuration) {
            this.configuration = configuration;
            this.basePath = configuration.basePath || this.basePath;
        }
    }
};

/**
 *
 * @export
 * @class RequiredError
 * @extends {Error}
 */
export class RequiredError extends Error {
    name: "RequiredError"
    constructor(public field: string, msg?: string) {
        super(msg);
    }
}

/**
 * 
 * @export
 * @interface ResponseUnauthorized
 */
export interface ResponseUnauthorized {
    /**
     * 
     * @type {number}
     * @memberof ResponseUnauthorized
     */
    code?: number;
    /**
     * 
     * @type {string}
     * @memberof ResponseUnauthorized
     */
    message?: string;
    /**
     * 
     * @type {any}
     * @memberof ResponseUnauthorized
     */
    data?: any;
}
/**
 * 
 * @export
 * @interface ResponseUnhandled
 */
export interface ResponseUnhandled {
    /**
     * 
     * @type {number}
     * @memberof ResponseUnhandled
     */
    code?: number;
    /**
     * 
     * @type {string}
     * @memberof ResponseUnhandled
     */
    message?: string;
    /**
     * 
     * @type {any}
     * @memberof ResponseUnhandled
     */
    data?: any;
}
/**
 * 
 * @export
 * @interface SingleSignupPayload
 */
export interface SingleSignupPayload {
    /**
     * Event type.
     * @type {string}
     * @memberof SingleSignupPayload
     */
    event: SingleSignupPayload.EventEnum;
    /**
     * user's id
     * @type {string}
     * @memberof SingleSignupPayload
     */
    sub: string;
    /**
     * required if event = activate
     * @type {string}
     * @memberof SingleSignupPayload
     */
    firstName?: string;
    /**
     * required if event = activate
     * @type {string}
     * @memberof SingleSignupPayload
     */
    lastName?: string;
    /**
     * 
     * @type {string}
     * @memberof SingleSignupPayload
     */
    maternalLastName?: string;
    /**
     * 
     * @type {string}
     * @memberof SingleSignupPayload
     */
    email: string;
    /**
     * 
     * @type {SingleSignupPayloadLocalIdentifier}
     * @memberof SingleSignupPayload
     */
    localIdentifier: SingleSignupPayloadLocalIdentifier;
    /**
     * 
     * @type {SingleSignupPayloadPlan}
     * @memberof SingleSignupPayload
     */
    plan: SingleSignupPayloadPlan;
    /**
     * required if event = activate
     * @type {string}
     * @memberof SingleSignupPayload
     */
    locale?: SingleSignupPayload.LocaleEnum;
}

/**
 * @export
 * @namespace SingleSignupPayload
 */
export namespace SingleSignupPayload {
    /**
     * @export
     * @enum {string}
     */
    export enum EventEnum {
        Activate = <any> 'activate',
        Deactivate = <any> 'deactivate'
    }
    /**
     * @export
     * @enum {string}
     */
    export enum LocaleEnum {
        En = <any> 'en',
        Es = <any> 'es',
        Pt = <any> 'pt'
    }
}
/**
 * User's unique identifying data
 * @export
 * @interface SingleSignupPayloadLocalIdentifier
 */
export interface SingleSignupPayloadLocalIdentifier {
    /**
     * 
     * @type {number}
     * @memberof SingleSignupPayloadLocalIdentifier
     */
    idTypeId?: number;
    /**
     * 
     * @type {string}
     * @memberof SingleSignupPayloadLocalIdentifier
     */
    idType?: string;
    /**
     * 
     * @type {string}
     * @memberof SingleSignupPayloadLocalIdentifier
     */
    idValue?: string;
}
/**
 * User's subscription plan
 * @export
 * @interface SingleSignupPayloadPlan
 */
export interface SingleSignupPayloadPlan {
    /**
     * 
     * @type {number}
     * @memberof SingleSignupPayloadPlan
     */
    id?: number;
    /**
     * 
     * @type {string}
     * @memberof SingleSignupPayloadPlan
     */
    startDate?: string;
}
/**
 * 
 * @export
 * @interface TransactionCreated
 */
export interface TransactionCreated {
    /**
     * 0 indicates that it is a sucess response
     * @type {number}
     * @memberof TransactionCreated
     */
    code?: number;
    /**
     * Response message
     * @type {string}
     * @memberof TransactionCreated
     */
    message?: string;
    /**
     * Transaction UUID
     * @type {string}
     * @memberof TransactionCreated
     */
    trx?: string;
    /**
     * 
     * @type {SingleSignupPayload}
     * @memberof TransactionCreated
     */
    data?: SingleSignupPayload;
}
/**
 * 
 * @export
 * @interface TransactionMultipleCreated
 */
export interface TransactionMultipleCreated {
    /**
     * 0 indicates that it is a sucess response
     * @type {number}
     * @memberof TransactionMultipleCreated
     */
    code?: number;
    /**
     * Response message
     * @type {string}
     * @memberof TransactionMultipleCreated
     */
    message?: string;
    /**
     * Transaction UUID
     * @type {string}
     * @memberof TransactionMultipleCreated
     */
    trx?: string;
    /**
     * 
     * @type {any}
     * @memberof TransactionMultipleCreated
     */
    data?: any;
}
/**
 * 
 * @export
 * @interface TransactionNotFound
 */
export interface TransactionNotFound {
    /**
     * 
     * @type {number}
     * @memberof TransactionNotFound
     */
    code?: number;
    /**
     * 
     * @type {string}
     * @memberof TransactionNotFound
     */
    message?: string;
    /**
     * 
     * @type {any}
     * @memberof TransactionNotFound
     */
    data?: any;
}
/**
 * 
 * @export
 * @interface TransactionResult
 */
export interface TransactionResult {
    /**
     * 
     * @type {string}
     * @memberof TransactionResult
     */
    trx?: string;
    /**
     * added to single user transactions only
     * @type {string}
     * @memberof TransactionResult
     */
    event?: TransactionResult.EventEnum;
    /**
     * Transaction result, true = success.
     * @type {boolean}
     * @memberof TransactionResult
     */
    result?: boolean;
    /**
     * Response's additional info
     * @type {string}
     * @memberof TransactionResult
     */
    message?: string;
}

/**
 * @export
 * @namespace TransactionResult
 */
export namespace TransactionResult {
    /**
     * @export
     * @enum {string}
     */
    export enum EventEnum {
        Activate = <any> 'activate',
        Deactivate = <any> 'deactivate'
    }
}
/**
 * 
 * @export
 * @interface TransactionRetryBody
 */
export interface TransactionRetryBody {
    /**
     * Transaction's uuid
     * @type {string}
     * @memberof TransactionRetryBody
     */
    uuid?: string;
}
/**
 * 
 * @export
 * @interface UsersBody
 */
export interface UsersBody {
    /**
     * 
     * @type {Blob}
     * @memberof UsersBody
     */
    file?: Blob;
}
/**
 * 
 * @export
 * @interface ValidationError
 */
export interface ValidationError {
    /**
     * 1 = there is an error, 0 = sucess response
     * @type {number}
     * @memberof ValidationError
     */
    code?: number;
    /**
     * Error
     * @type {string}
     * @memberof ValidationError
     */
    message?: string;
    /**
     * 
     * @type {ValidationErrorData}
     * @memberof ValidationError
     */
    data?: ValidationErrorData;
}
/**
 * Additional info returned
 * @export
 * @interface ValidationErrorData
 */
export interface ValidationErrorData {
    /**
     * 
     * @type {ValidationErrorDataErrors}
     * @memberof ValidationErrorData
     */
    errors?: ValidationErrorDataErrors;
}
/**
 * 
 * @export
 * @interface ValidationErrorDataErrors
 */
export interface ValidationErrorDataErrors {
    /**
     * 
     * @type {ValidationErrorDataErrorsFiedName}
     * @memberof ValidationErrorDataErrors
     */
    fiedName?: ValidationErrorDataErrorsFiedName;
}
/**
 * 
 * @export
 * @interface ValidationErrorDataErrorsFiedName
 */
export interface ValidationErrorDataErrorsFiedName {
    /**
     * 
     * @type {string}
     * @memberof ValidationErrorDataErrorsFiedName
     */
    message?: string;
    /**
     * 
     * @type {string}
     * @memberof ValidationErrorDataErrorsFiedName
     */
    rule?: string;
}
/**
 * TransactionsApi - fetch parameter creator
 * @export
 */
export const TransactionsApiFetchParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Retrieves a transaction status by it's uuid.
         * @summary Get transaction by uuid.
         * @param {string} uuid Transaction&#x27;s uuid
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        transactionGet(uuid: string, options: any = {}): FetchArgs {
            // verify required parameter 'uuid' is not null or undefined
            if (uuid === null || uuid === undefined) {
                throw new RequiredError('uuid','Required parameter uuid was null or undefined when calling transactionGet.');
            }
            const localVarPath = `/transaction`;
            const localVarUrlObj = url.parse(localVarPath, true);
            const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication signature required
            if (configuration && configuration.apiKey) {
                const localVarApiKeyValue = typeof configuration.apiKey === 'function'
					? configuration.apiKey("betterfly-signature")
					: configuration.apiKey;
                localVarHeaderParameter["betterfly-signature"] = localVarApiKeyValue;
            }

            if (uuid !== undefined) {
                localVarQueryParameter['uuid'] = uuid;
            }

            localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query);
            // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
            delete localVarUrlObj.search;
            localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

            return {
                url: url.format(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
         * @summary Retries a transaction
         * @param {TransactionRetryBody} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        transactionRetryPost(body?: TransactionRetryBody, options: any = {}): FetchArgs {
            const localVarPath = `/transaction/retry`;
            const localVarUrlObj = url.parse(localVarPath, true);
            const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication signature required
            if (configuration && configuration.apiKey) {
                const localVarApiKeyValue = typeof configuration.apiKey === 'function'
					? configuration.apiKey("betterfly-signature")
					: configuration.apiKey;
                localVarHeaderParameter["betterfly-signature"] = localVarApiKeyValue;
            }

            localVarHeaderParameter['Content-Type'] = 'application/json';

            localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query);
            // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
            delete localVarUrlObj.search;
            localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
            const needsSerialization = (<any>"TransactionRetryBody" !== "string") || localVarRequestOptions.headers['Content-Type'] === 'application/json';
            localVarRequestOptions.body =  needsSerialization ? JSON.stringify(body || {}) : (body || "");

            return {
                url: url.format(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * TransactionsApi - functional programming interface
 * @export
 */
export const TransactionsApiFp = function(configuration?: Configuration) {
    return {
        /**
         * Retrieves a transaction status by it's uuid.
         * @summary Get transaction by uuid.
         * @param {string} uuid Transaction&#x27;s uuid
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        transactionGet(uuid: string, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<TransactionResult> {
            const localVarFetchArgs = TransactionsApiFetchParamCreator(configuration).transactionGet(uuid, options);
            return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
                return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then((response) => {
                    if (response.status >= 200 && response.status < 300) {
                        return response.json();
                    } else {
                        throw response;
                    }
                });
            };
        },
        /**
         * Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
         * @summary Retries a transaction
         * @param {TransactionRetryBody} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        transactionRetryPost(body?: TransactionRetryBody, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<TransactionCreated> {
            const localVarFetchArgs = TransactionsApiFetchParamCreator(configuration).transactionRetryPost(body, options);
            return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
                return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then((response) => {
                    if (response.status >= 200 && response.status < 300) {
                        return response.json();
                    } else {
                        throw response;
                    }
                });
            };
        },
    }
};

/**
 * TransactionsApi - factory interface
 * @export
 */
export const TransactionsApiFactory = function (configuration?: Configuration, fetch?: FetchAPI, basePath?: string) {
    return {
        /**
         * Retrieves a transaction status by it's uuid.
         * @summary Get transaction by uuid.
         * @param {string} uuid Transaction&#x27;s uuid
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        transactionGet(uuid: string, options?: any) {
            return TransactionsApiFp(configuration).transactionGet(uuid, options)(fetch, basePath);
        },
        /**
         * Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
         * @summary Retries a transaction
         * @param {TransactionRetryBody} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        transactionRetryPost(body?: TransactionRetryBody, options?: any) {
            return TransactionsApiFp(configuration).transactionRetryPost(body, options)(fetch, basePath);
        },
    };
};

/**
 * TransactionsApi - object-oriented interface
 * @export
 * @class TransactionsApi
 * @extends {BaseAPI}
 */
export class TransactionsApi extends BaseAPI {
    /**
     * Retrieves a transaction status by it's uuid.
     * @summary Get transaction by uuid.
     * @param {string} uuid Transaction&#x27;s uuid
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TransactionsApi
     */
    public transactionGet(uuid: string, options?: any) {
        return TransactionsApiFp(this.configuration).transactionGet(uuid, options)(this.fetch, this.basePath);
    }

    /**
     * Finds a transaction by its uuid and makes a retry if the transaction has a previous failed intent.
     * @summary Retries a transaction
     * @param {TransactionRetryBody} [body] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TransactionsApi
     */
    public transactionRetryPost(body?: TransactionRetryBody, options?: any) {
        return TransactionsApiFp(this.configuration).transactionRetryPost(body, options)(this.fetch, this.basePath);
    }

}
/**
 * UsersApi - fetch parameter creator
 * @export
 */
export const UsersApiFetchParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Creates a new user. If already exists, user's data will be updated.
         * @summary Creates or updates an user.
         * @param {SingleSignupPayload} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        userPost(body?: SingleSignupPayload, options: any = {}): FetchArgs {
            const localVarPath = `/user`;
            const localVarUrlObj = url.parse(localVarPath, true);
            const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication signature required
            if (configuration && configuration.apiKey) {
                const localVarApiKeyValue = typeof configuration.apiKey === 'function'
					? configuration.apiKey("betterfly-signature")
					: configuration.apiKey;
                localVarHeaderParameter["betterfly-signature"] = localVarApiKeyValue;
            }

            localVarHeaderParameter['Content-Type'] = 'application/json';

            localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query);
            // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
            delete localVarUrlObj.search;
            localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
            const needsSerialization = (<any>"SingleSignupPayload" !== "string") || localVarRequestOptions.headers['Content-Type'] === 'application/json';
            localVarRequestOptions.body =  needsSerialization ? JSON.stringify(body || {}) : (body || "");

            return {
                url: url.format(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Creates or update multiple users based on the input file.
         * @summary Creates or updates multiple users.
         * @param {Blob} [file] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        usersPost(file?: Blob, options: any = {}): FetchArgs {
            const localVarPath = `/users`;
            const localVarUrlObj = url.parse(localVarPath, true);
            const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new url.URLSearchParams();

            // authentication signature required
            if (configuration && configuration.apiKey) {
                const localVarApiKeyValue = typeof configuration.apiKey === 'function'
					? configuration.apiKey("betterfly-signature")
					: configuration.apiKey;
                localVarHeaderParameter["betterfly-signature"] = localVarApiKeyValue;
            }

            if (file !== undefined) {
                localVarFormParams.set('file', file as any);
            }

            localVarHeaderParameter['Content-Type'] = 'application/x-www-form-urlencoded';

            localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query);
            // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
            delete localVarUrlObj.search;
            localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
            localVarRequestOptions.body = localVarFormParams.toString();

            return {
                url: url.format(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * UsersApi - functional programming interface
 * @export
 */
export const UsersApiFp = function(configuration?: Configuration) {
    return {
        /**
         * Creates a new user. If already exists, user's data will be updated.
         * @summary Creates or updates an user.
         * @param {SingleSignupPayload} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        userPost(body?: SingleSignupPayload, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<TransactionCreated> {
            const localVarFetchArgs = UsersApiFetchParamCreator(configuration).userPost(body, options);
            return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
                return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then((response) => {
                    if (response.status >= 200 && response.status < 300) {
                        return response.json();
                    } else {
                        throw response;
                    }
                });
            };
        },
        /**
         * Creates or update multiple users based on the input file.
         * @summary Creates or updates multiple users.
         * @param {Blob} [file] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        usersPost(file?: Blob, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<TransactionMultipleCreated> {
            const localVarFetchArgs = UsersApiFetchParamCreator(configuration).usersPost(file, options);
            return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
                return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then((response) => {
                    if (response.status >= 200 && response.status < 300) {
                        return response.json();
                    } else {
                        throw response;
                    }
                });
            };
        },
    }
};

/**
 * UsersApi - factory interface
 * @export
 */
export const UsersApiFactory = function (configuration?: Configuration, fetch?: FetchAPI, basePath?: string) {
    return {
        /**
         * Creates a new user. If already exists, user's data will be updated.
         * @summary Creates or updates an user.
         * @param {SingleSignupPayload} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        userPost(body?: SingleSignupPayload, options?: any) {
            return UsersApiFp(configuration).userPost(body, options)(fetch, basePath);
        },
        /**
         * Creates or update multiple users based on the input file.
         * @summary Creates or updates multiple users.
         * @param {Blob} [file] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        usersPost(file?: Blob, options?: any) {
            return UsersApiFp(configuration).usersPost(file, options)(fetch, basePath);
        },
    };
};

/**
 * UsersApi - object-oriented interface
 * @export
 * @class UsersApi
 * @extends {BaseAPI}
 */
export class UsersApi extends BaseAPI {
    /**
     * Creates a new user. If already exists, user's data will be updated.
     * @summary Creates or updates an user.
     * @param {SingleSignupPayload} [body] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UsersApi
     */
    public userPost(body?: SingleSignupPayload, options?: any) {
        return UsersApiFp(this.configuration).userPost(body, options)(this.fetch, this.basePath);
    }

    /**
     * Creates or update multiple users based on the input file.
     * @summary Creates or updates multiple users.
     * @param {Blob} [file] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UsersApi
     */
    public usersPost(file?: Blob, options?: any) {
        return UsersApiFp(this.configuration).usersPost(file, options)(this.fetch, this.basePath);
    }

}
